$(document).ready(function(){
	// Standard
	jQuery('.tabs.standard .tab-links a').on('click', function(e)  {
		var currentAttrValue = jQuery(this).attr('href');

		// Show/Hide Tabs
		jQuery('.tabs ' + currentAttrValue).show().siblings().hide();

		// Change/remove current tab to active
		jQuery(this).parent('li').addClass('active').siblings().removeClass('active');

		e.preventDefault();
	});

	// Animated Fade
	jQuery('.tabs.animated-fade .tab-links a').on('click', function(e)  {
		var currentAttrValue = jQuery(this).attr('href');

		// Show/Hide Tabs
		jQuery('.tabs ' + currentAttrValue).fadeIn(400).siblings().hide();

		// Change/remove current tab to active
		jQuery(this).parent('li').addClass('active').siblings().removeClass('active');

		e.preventDefault();
	});

	// Animated Slide 1
	jQuery('.tabs.animated-slide-1 .tab-links a').on('click', function(e)  {
		var currentAttrValue = jQuery(this).attr('href');

		// Show/Hide Tabs
		jQuery('.tabs ' + currentAttrValue).siblings().slideUp(400);
		jQuery('.tabs ' + currentAttrValue).delay(400).slideDown(400);

		// Change/remove current tab to active
		jQuery(this).parent('li').addClass('active').siblings().removeClass('active');

		e.preventDefault();
	});

	

	$('.sliderImg').slick({
	dots: true,
	infinite: true,
	autoplay: true,
  	autoplaySpeed: 2000,
  	// speed: 300,
  	slidesToShow: 1,
  	adaptiveHeight: true
  	});
	
786

	$('.cal').slick({
	infinite: true,
	speed: 300,
	slidesToShow: 5,
	slidesToScroll: 1,
	autoplay: true,
	autoplaySpeed: 2000,
	centerMode: true,
		responsive: [
		{
		  breakpoint: 964,
		  settings: {
		    centerMode: true,
		    slidesToShow: 4
		  }
		},
		{
		  breakpoint: 787,
		  settings: {
		    centerMode: true,
		    slidesToShow: 3
		  }
		}
  ]
  });


});



